/*!
 * @nuxt/vue-app v2.16.3 (c) 2016-2023
 * Released under the MIT License
 * Repository: https://github.com/nuxt/nuxt.js
 * Website: https://nuxtjs.org
*/
'use strict';

const path = require('path');

var dependencies = {
	"node-fetch-native": "^1.0.2",
	ufo: "^1.1.1",
	unfetch: "^5.0.0",
	vue: "^2.7.10",
	"vue-client-only": "^2.1.0",
	"vue-meta": "^2.4.0",
	"vue-no-ssr": "^1.1.1",
	"vue-router": "^3.6.5",
	"vue-template-compiler": "^2.7.14",
	vuex: "^3.6.2"
};

const template = {
  dependencies,
  dir: path.join(__dirname, "..", "template"),
  files: [
    "App.js",
    "client.js",
    "index.js",
    "jsonp.js",
    "router.js",
    "router.scrollBehavior.js",
    "routes.json",
    "server.js",
    "utils.js",
    "empty.js",
    "mixins/fetch.server.js",
    "mixins/fetch.client.js",
    "components/nuxt-error.vue",
    "components/nuxt-child.js",
    "components/nuxt-link.server.js",
    "components/nuxt-link.client.js",
    "components/nuxt.js",
    "views/app.template.html",
    "views/error.html"
  ]
};

exports.template = template;
