import { defineNuxtModule, addImports } from '@nuxt/kit';
import * as lodash from 'lodash-es';

const exculdeDefaults = [
  "wrapperValue",
  "wrapperToIterator",
  "wrapperReverse",
  "wrapperPlant",
  "wrapperNext",
  "wrapperLodash",
  "wrapperCommit",
  "wrapperChain",
  "wrapperAt",
  "templateSettings",
  "toIterator",
  "VERSION",
  "lodash",
  "value",
  "valueOf",
  "toJSON",
  "thru",
  "plant",
  "next",
  "default",
  "commit",
  "head"
];

const module = defineNuxtModule({
  meta: {
    name: "nuxt-lodash",
    configKey: "lodash",
    compatibility: {
      nuxt: "^3.0.0"
    }
  },
  defaults: {
    prefix: "use",
    prefixSkip: "is",
    exclude: [],
    alias: [],
    upperAfterPrefix: true
  },
  setup(options, nuxt) {
    const aliasMap = new Map(options.alias);
    const exludes = [...options.exclude, ...exculdeDefaults];
    const prefixSkip = options.prefixSkip ? lodash.isArray(options.prefixSkip) ? options.prefixSkip : [options.prefixSkip] : [];
    for (const name of Object.keys(lodash)) {
      if (!exludes.includes(name)) {
        const alias = aliasMap.has(name) ? aliasMap.get(name) : name;
        const prefix = !prefixSkip.some((key) => alias.startsWith(key)) && options.prefix || "";
        const as = prefix ? prefix + (options.upperAfterPrefix ? lodash.upperFirst(alias) : alias) : alias;
        addImports({ name, as, from: "lodash-es" });
      }
    }
    nuxt.hook("vite:extend", ({ config }) => {
      var _a;
      config.optimizeDeps || (config.optimizeDeps = {});
      (_a = config.optimizeDeps).exclude || (_a.exclude = []);
      config.optimizeDeps.exclude.push("lodash-es");
    });
  }
});

export { module as default };
