<p align="center"><img alt="Nuxt" align="center" src="./.github/logo.svg"/></p><br/>
<p align="center">
  <a href="https://github.com/nuxt/nuxt.js/actions?query=branch%3Adev+event%3Apush"><img src="https://github.com/nuxt/nuxt.js/workflows/test/badge.svg?branch=dev&event=push" alt="Tests Status"></a>
  <a href="https://github.com/nuxt/nuxt.js/actions?query=branch%3Adev+event%3Apush"><img src="https://github.com/nuxt/nuxt.js/workflows/windows/badge.svg?branch=dev&event=push" alt="Windows Status"></a>
  <a href="https://codecov.io/gh/nuxt/nuxt.js"><img src="https://badgen.net/codecov/c/github/nuxt/nuxt.js/master" alt="Coverage Status"></a>
  <a href="https://www.npmjs.com/package/nuxt"><img src="https://badgen.net/npm/dm/nuxt" alt="Downloads"></a>
  <a href="https://www.npmjs.com/package/nuxt"><img src="https://badgen.net/npm/v/nuxt" alt="Version"></a>
  <a href="https://www.npmjs.com/package/nuxt"><img src="https://badgen.net/npm/license/nuxt" alt="License"></a>
  <a href="https://discord.nuxtjs.org/"><img src="https://badgen.net/badge/Discord/join-us/7289DA" alt="Discord"></a>
 </p>
 <p align="center">
  <a href="https://github.com/sponsors/nuxt"><img src="https://img.shields.io/badge/Support%20us-GitHub%20Sponsors-DB61A2.svg" alt="Support us"></a>
  <a href="https://oc.nuxtjs.org/"><img src="https://img.shields.io/badge/Support%20us-Open%20Collective-41B883.svg" alt="Support us"></a>
</p>

> Build your next Vue(2) application with confidence using Nuxt: a framework making web development simple and powerful.

## Nuxt 3

The evolution of Nuxt powered by Vite and Vue 3 available on:
- GitHub: [nuxt/framework](https://github.com/nuxt/framework)
- Documentation: [nuxt.com](https://nuxt.com/)

## Links

- 📘 Documentation: [https://nuxtjs.org](https://nuxtjs.org)
- 👥 Community: [GitHub discussions](https://github.com/nuxt/nuxt.js/discussions)
- 🎬 Video: [1 minute demo](https://www.youtube.com/watch?v=kmf-p-pTi40)
- 🐦 Twitter: [@nuxt_js](https://twitter.nuxtjs.org/)
- 💬 Chat: [Discord](https://discord.nuxtjs.org/)
- 🌟 [AwesomeNuxt](https://awesome.nuxtjs.org/)
- 👉 [Play with Nuxt online](https://template.nuxtjs.org)

## Features

- Automatic transpilation and bundling (with webpack and babel)
- Hot code reloading
- Server-side rendering OR Single Page App OR Static Generated, you choose :fire:
- Static file serving. `./static/` is mapped to `/`
- Configurable with a `nuxt.config.js` file
- Custom layouts with the `layouts/` directory
- Middleware
- Code splitting for every `pages/`
- Loading just the critical CSS (page-level)

Learn more at <https://nuxtjs.org>.

## Getting started

```sh
$ npx create-nuxt-app <project-name>
```

It's as simple as that!

Learn more at https://nuxtjs.org/guide/installation

## Examples

Please take a look at <https://nuxtjs.org/examples> or directly in <https://github.com/nuxt/nuxt.js/tree/dev/examples>.

## Production deployment

To deploy, instead of running nuxt, you probably want to build ahead of time. Therefore, building and starting are separate commands:

```bash
nuxt build
nuxt start
```

Learn more at https://nuxtjs.org/guide/commands#production-deployment

## Consulting from the Nuxt team

Get help with that tough bug or make sure your Nuxt app is ready to deploy. For $250 an hour, get technical support, advice and code reviews from the Nuxt core team: support@nuxtlabs.com

## Agency Network

When in need for more broad or long-term consulting, reach out for one of our [agency partner](https://nuxtjs.org/partners):


<p align="center">
  <a href="https://nuxtjs.org/partners/ship-shape"><img src="https://nuxtjs.org/img/companies/square/light/shipshape.webp" style="margin: 1rem" height="80px" alt="Ship Shape"></a>
  <a href="https://nuxtjs.org/partners/64robots"><img src="https://nuxtjs.org/img/companies/square/light/64robots.svg" style="margin: 1rem" height="80px" alt="64 Robots"></a>
  <a href="https://nuxtjs.org/partners/passionate-people"><img src="https://nuxtjs.org/img/companies/square/light/passionate-people.jpeg" style="margin: 1rem" height="80px" alt="Passionate people"></a>
  <a href="https://nuxtjs.org/partners/curotec"><img src="https://nuxtjs.org/img/companies/square/light/curotec.jpeg" style="margin: 1rem" height="80px" alt="Curotec"></a>
  <a href="https://nuxtjs.org/partners/mirahi"><img src="https://nuxtjs.org/img/companies/square/light/mirahi.svg" style="margin: 1rem" height="80px" alt="Mirahi"></a>
  <a href="https://nuxtjs.org/partners/webreinvent"><img src="https://nuxtjs.org/img/companies/square/light/webreinvent.svg" style="margin: 1rem" height="80px" alt="Web Reinvent"></a>
  <a href="https://nuxtjs.org/partners/software-things"><img src="https://nuxtjs.org/img/companies/square/light/software-things.svg" style="margin: 1rem" height="80px" alt="Software things"></a>
  <a href="https://nuxtjs.org/partners/zen-architects"><img src="https://nuxtjs.org/img/companies/square/light/zen-architects.svg" style="margin: 1rem" height="80px" alt="Zen Architects"></a>
  <a href="https://nuxtjs.org/partners/funkhaus"><img src="https://nuxtjs.org/img/companies/square/light/funkhaus.svg" style="margin: 1rem" height="80px" alt="Funkhaus"></a>
</p>

## Supporting Nuxt

Nuxt is an MIT-licensed open source project with its ongoing development made possible entirely by the support of these awesome backers.
Funds donated via OpenCollective are managed with transparent expenses and will be used for compensating work and expenses for core team members or sponsoring community events.

Support us with a monthly donation and help us continue our activities. [[Become a backer](https://opencollective.com/nuxtjs#contribute)]

[![Open Collective Platinum Sponsors][platinum-sponsors-src]][platinum-sponsors-href]

## Contributors

Thank you to all our [contributors](https://github.com/nuxt/nuxt.js/graphs/contributors)!

[![Nuxt Contributors][contributors-src]][contributors-href]

## Contributing

[![Open in Gitpod](https://gitpod.io/button/open-in-gitpod.svg)](https://gitpod.io/#https://github.com/nuxt/nuxt.js)

Please refer to our [Contribution Guide](https://nuxtjs.org/contribution-guide/)

## Cross-browser testing

<a href="https://browserstack.com"><img height="30" align="center" src=".github/icons/browserstack.svg" alt="BrowserStack"></a> Thanks to [BrowserStack](http://browserstack.com)!

## Automated testing

<a href="https://saucelabs.com"><img height="30" align="center" src=".github/icons/saucelabs.svg" alt="SauceLabs"></a> Thanks to [SauceLabs](https://saucelabs.com) for supporting Open Source <3

## Security

If you discover a security vulnerability regarding Nuxt, please send an e-mail to the team via security@nuxtjs.org! All security vulnerabilities will be promptly addressed.

## License

[MIT](https://github.com/nuxt/nuxt.js/blob/dev/LICENSE)

<!-- Open Collective Tiers -->
[platinum-sponsors-src]: https://opencollective.com/nuxtjs/tiers/platinum-sponsors.svg?avatarHeight=96&width=890
[platinum-sponsors-href]: https://opencollective.com/nuxtjs#contributors
[gold-sponsors-src]: https://opencollective.com/nuxtjs/tiers/gold-sponsors.svg?avatarHeight=80&width=890
[gold-sponsors-href]: https://opencollective.com/nuxtjs#contributors
[silver-sponsors-src]: https://opencollective.com/nuxtjs/tiers/silver-sponsors.svg?avatarHeight=64&width=890
[silver-sponsors-href]: https://opencollective.com/nuxtjs#contributors
[bronze-sponsors-src]: https://opencollective.com/nuxtjs/tiers/bronze-sponsors.svg?avatarHeight=48&width=890
[bronze-sponsors-href]: https://opencollective.com/nuxtjs#contributors
[nuxters-src]: https://opencollective.com/nuxtjs/tiers/nuxters.svg?width=890&button=false
[nuxters-href]: https://opencollective.com/nuxtjs#contributors
[contributors-src]: https://opencollective.com/nuxtjs/contributors.svg?width=890&button=false
[contributors-href]: https://github.com/nuxt/nuxt.js/graphs/contributors
