export default {
  mode: "spa",
  head: {
    titleTemplate: "%s - BrightSkills",
    title: "BrightSkills",
    htmlAttrs: {
      lang: "en",
    },
    meta: [
      { charset: "utf-8" },
      { name: "viewport", content: "width=device-width, initial-scale=1" },
      { hid: "description", name: "description", content: "" },
      { name: "format-detection", content: "telephone=no" },
      { hid: "og:image", property: "og:image", content: "" },
    ],
    link: [
      {
        rel: "icon",
        type: "image/x-icon",
        href: "https://api.brightskills.com/favicon.png",
      },
      {
        rel: "stylesheet",
        href: "https://cdn.jsdelivr.net/npm/@mdi/font@latest/css/materialdesignicons.min.css",
      },
      {
        rel: "stylesheet",
        href: "https://fonts.googleapis.com/css?family=Roboto:100,300,400,500,700,900",
      },
      {
        rel: "stylesheet",
        href: "https://fonts.googleapis.com/css?family=Hind+Siliguri:300,400,500,600,700|Source+Sans+Pro:300,400,500,600,700|Roboto:300,400,500,700,900&amp;display=swap",
      },
      {
        rel: "stylesheet",
        href: "https://fonts.googleapis.com/css2?family=Arimo:ital,wght@0,400..700;1,400..700&family=Poppins:ital,wght@0,100;0,200;0,300;0,400;0,500;0,600;0,700;0,800;1,100;1,200;1,300;1,400;1,500;1,600;1,700&family=Roboto:ital,wght@0,400;0,500;0,700;1,400;1,500;1,700&display=swap",
      },
      {
        rel: "stylesheet",
        href: "//cdn.jsdelivr.net/npm/slick-carousel@1.8.1/slick/slick.css",
        type: "text/css",
      },
    ],
    script: [
      {
        src: "/js/jquery-3.5.1.min.js",
        type: "text/javascript",
        body: true,
        ssr: false,
      },
      {
        src: "/js/bootstrap.bundle.min.js",
        type: "text/javascript",
        body: true,
        ssr: false,
      },
      {
        src: "/js/owl.carousel.min.js",
        type: "text/javascript",
        body: true,
        ssr: false,
      },
      {
        src: "https://www.googletagmanager.com/gtag/js?id=G-VBGH0LD715",
        type: "text/javascript",
        async: true,
      },
      { src: "/js/gtag.js", type: "text/javascript" },
      { src: "/js/gtag-bs.js", type: "text/javascript" },
      { src: "/js/fbpixel.js", type: "text/javascript" },
      {
        src: "/js/cartdropdown.js",
        type: "text/javascript",
        body: true,
        ssr: false,
      },
      // { src: "/js/header.js", type: "text/javascript", body: true, ssr: false },
      {
        src: "/js/carousel.js",
        type: "text/javascript",
        body: true,
        ssr: false,
      },
      {
        src: "/js/tooltip.js",
        type: "text/javascript",
        body: true,
        ssr: false,
      },
      { src: "/js/custom.js", type: "text/javascript", body: true, ssr: false },
      // { src: "/js/tawk.js", type: "text/javascript" },
    ],
  },
  css: [
    "view-design/dist/styles/iview.css",
    "vue-slick-carousel/dist/vue-slick-carousel.css",
    "vue-slick-carousel/dist/vue-slick-carousel-theme.css",
    "./assets/css/bootstrap.min.css",
    "./assets/css/slick.css",
    "./assets/css/style.css",
    "./assets/css/media.css",
    "./assets/css/responsive.css",
    "./assets/css/font-awesome.css",
  ],

  plugins: [
    // { src: "~/plugins/vform.js", mode: "client" }
    { src: "~/plugins/global-components.js", mode: "client" },
    "~/plugins/lodash",
    { src: `~plugins/vimeo-player`, mode: "client" },
    { src: `~plugins/vue-awesome-countdown`, mode: "client" },
    { src: `~plugins/iview`, mode: "client" },
    { src: "~/plugins/jquery.js", mode: "client" },
    { src: "~/plugins/gtm.js", mode: "client" },
    { src: "~/plugins/vue-fb-customer-chat.js", mode: "client" },
  ],

  components: true,

  buildModules: [],

  modules: [
    "@nuxtjs/router",
    "@nuxtjs/axios",
    "@nuxtjs/auth-next",
    "@nuxtjs/toast",
    "@nuxtjs/gtm",
  ],
  gtm: {
    enabled: true,
    id: "GTM-P7BDN3D",
    pageTracking: true,
  },
  auth: {
    strategies: {
      local: {
        token: {
          property: "token",
          global: true,
          // required: true,
          // type: 'Bearer'
        },
        user: {
          property: "user",
          // autoFetch: true
        },
        endpoints: {
          login: { url: "/student/auth/login", method: "post" },
          logout: { url: "/student/auth/logout", method: "post" },
          user: { url: "/student/auth/me", method: "post" },
        },
      },
    },
    redirect: {
      login: "/login",
      logout: "/",
      callback: "/login",
      home: "/dashboard",
    },
  },
  router: {
    extendRoutes(routes, resolve) {
      const routers = [...require("./router/route.js").default];
      routes.push(...routers);
    },
  },
  axios: {
    baseURL: "https://api.brightskills.com/api",
  },
  toast: {
    position: "top-center",
    keepOnHover: true,
    duration: 5000,
    // register: [ // Register custom toasts
    //   {
    //     name: 'my-error',
    //     message: 'Oops...Something went wrong',
    //     options: {
    //       type: 'error'
    //     }
    //   }
    // ]
  },

  vuetify: {},

  build: {
    filenames: {
      chunk: ({ isDev }) => (isDev ? "[name].js" : "[chunkhash].js"),
    },
    transpile: ["defu"],
    vendor: ["vue-vimeo-player", "vue-youtube"],
  },
};
